package com.chatley.examples.auction;

public class Scenarios {

	public static Scenario startsTheBidding() {
		return new Scenario() {

			public boolean holdsIn(AuctionContext currentSituation) {
				return noBidsHaveHappened(currentSituation);
			}

			private boolean noBidsHaveHappened(AuctionContext currentSituation) {
				return currentSituation.bidsSoFar() == 0;
			}
		};
	}
	
	public static Scenario anotherBidderBids() {
		return new Scenario() {

			public boolean holdsIn(AuctionContext currentSituation) {
				return currentSituation.bidsSoFar() > 0;
			}
		};
	}
}
