package com.chatley.examples.auction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Bidder implements Participant {

	private String name;
	private Scenario scenario;
	
	private Map<Scenario, BiddingStrategy> rules = new HashMap<Scenario, BiddingStrategy>();
	private AuctionContext currentSituation = new AuctionContext();

	void called(String name){
		this.name = name;
	}
	
	Bidder when(Scenario scenario) {
		this.scenario = scenario;
		return this;
	}
	
	public String getName() {
		return name;
	}

	public void onBidAccepted(int price) {
		currentSituation.remember(new Bid(price));
	}

	public void onYourTurnToBid(BidReceiver receiver) {
		for (Scenario scenario : rules.keySet()) {
			if (scenario.holdsIn(currentSituation)) {
				receiver.bid(rules.get(scenario).applyIn(currentSituation));
			}
		}
	}

	public void bids(BiddingStrategy strategy) {
		rules.put(scenario, strategy);
	}

	public void bids(int i) {
		bids(FixedBid(i));
	}

	private BiddingStrategy FixedBid(final int amount) {
		return new BiddingStrategy() {

			public int applyIn(AuctionContext currentSituation) {
				return amount;
			}};
	}
}

class Bid {

	private final int amount;

	public Bid(int amount) {
		this.amount = amount;
	}

	public int value() {
		return amount;
	}
	
}

class AuctionContext {

	List<Bid> bids = new ArrayList<Bid>();
	
	public int bidsSoFar() {
		return bids.size();
	}

	public void remember(Bid bid) {
		bids.add(bid);
	}

	public int latestBid() {
		return bids.get(bids.size() - 1).value();
	}
	
}